<?php
header('Content-Type: application/json');
require_once 'db.php';

$response = ['success' => false, 'message' => ''];

try {
    // Get input data
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        $input = $_POST; // Fallback to regular POST data
    }

    // Validate required fields
    $required = ['order_id', 'invoice_id', 'customer_id', 'payment_amount', 'refunding_amount'];
    foreach ($required as $field) {
        if (empty($input[$field])) {
            throw new Exception("Missing required field: $field");
        }
    }

    // Sanitize input data
    $order_id = $conn->real_escape_string($input['order_id']);
    $invoice_id = $conn->real_escape_string($input['invoice_id']);
    $customer_id = $conn->real_escape_string($input['customer_id']);
    $totalamount = $conn->real_escape_string($input['totalamount']);
    $refunding_amount = floatval($input['refunding_amount']);
    $calculated_balance = $payment_amount - $refunding_amount;
    $payment_type = intval($input['payment_type']);
    $description = $conn->real_escape_string($input['description'] ?? '');
    $payment_date = $conn->real_escape_string($input['payment_date'] ?? date('Y-m-d'));

    // Create SQL query
    $sql = "INSERT INTO payment (
        Order_id, 
        Invoice_id, 
        customer_id, 
        Amount,
        refund_amount, 
        balance_amount, 
        Payment_type, 
        note, 
        refund_date
    ) VALUES (
        '$order_id',
        '$invoice_id',
        '$customer_id',
        $totalamount,
        $refunding_amount,
        $calculated_balance,
        $payment_type,
        '$description',
        '$payment_date'
    )";

    // Execute query
    if ($conn->query($sql)) {
        $response['success'] = true;
        $response['message'] = 'Payment recorded successfully';
        $response['payment_id'] = $conn->insert_id;
    } else {
        throw new Exception("Database error: " . $conn->error);
    }
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

// Close connection
$conn->close();

echo json_encode($response);
?>